#ifndef _CANVAS_H
#define _CANVAS_H

#include <QtGui>
#include <QGraphicsTextItem>

class Table;
class Arrow;
class PrimaryKey;
class Attribute;
class Name;

class Canvas : public QGraphicsScene
{
	Q_OBJECT

	public:
		enum Mode { MoveItem=1, InsertTable, InsertLine1, InsertLine2, InsertLine3};

	public:
		Canvas(QObject *parent = 0);
		virtual ~Canvas();

	public slots:
		void editorLostFocus1(Name *item);
		void editorLostFocus2(PrimaryKey *item);
		void editorLostFocus3(Attribute *item);
		void Save();
		void Open();

	signals:
		void itemInserted(Table* table);
		void itemInserted(Arrow* arrow);

	public:
		void GetDeleteList(Arrow* arrow, QList<PrimaryKey*>& deleteList);
		void GetDeleteList(Arrow* arrow, QList<Attribute*>& deleteList);
		
		//void editorLostFocus(QGraphicsTextItem *item);

	public:
		Mode GetMode() const;
		Table* GetCurrentItem() const;
		void SetMode(const Mode mode);
		void CorrectTable(Table* table);
		QList<Table*> GetTables() const;
		QList<Arrow*> GetArrows() const;
		//QList<Arrow*> GetTables() const;
		Arrow* GetArrow() const;

		int a;
		//void DrawTable(Table* table);

	protected:
		void mousePressEvent(QGraphicsSceneMouseEvent* mouseEvent);
		void mouseMoveEvent(QGraphicsSceneMouseEvent *mouseEvent);
		void mouseReleaseEvent(QGraphicsSceneMouseEvent *mouseEvent);
		void keyPressEvent ( QKeyEvent * keyEvent );
		
	private:
		int tableIndex;
		Mode mode;
		Table* currentItem;
		QGraphicsLineItem *line;
		Arrow* arrow;
		QList<Table*> tables;
		QList<Arrow*> arrows;
};

inline Arrow* Canvas::GetArrow() const
{
	return this->arrow;
}

inline QList<Table*> Canvas::GetTables() const
{
	return this->tables;
}

inline Canvas::Mode Canvas::GetMode() const
{
	return this->mode;
}

inline Table* Canvas::GetCurrentItem() const
{
	return this->currentItem;
}

inline void Canvas::SetMode(const Mode mode)
{
	this->mode = mode;
}

inline QList<Arrow*> Canvas::GetArrows() const
{
	return this->arrows;
}

#endif //_CANVAS_H
